<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Album de Fotos</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <?php
    $inicio = glob("../../imagenes/noimagen.png" , GLOB_BRACE);
    $australia = glob("../../html/album_fotos/australia/*.{jpg,jpeg,png,gif,avif,webp}", GLOB_BRACE);
    $costa_rica =  glob("../../html/album_fotos/costarica/*.{jpg,jpeg,png,gif,avif,webp}", GLOB_BRACE);
    $italia = glob("../../html/album_fotos/italia/*.{jpg,jpeg,png,gif,avif,webp}", GLOB_BRACE);
    $albunes = [
        'inicio' => $inicio,
        'australia' => $australia,
        'costarica' => $costa_rica,
        'italia' => $italia
    ];

    $carpetaSelecionada = isset($_GET['album']) ? $_GET['album'] : '';
    $posicion = isset($_GET['foto']) ? (int)$_GET['foto'] : 0;
    ?>

    <header>
        <h1>Album de Fotos</h1>
        <nav>
            <ul>
                <li><a href="?album=inicio">INICIO</a></li>
                <li><a href="?album=australia">Viaje a Australia</a></li>
                <li><a href="?album=costarica">Viaje a Costa Rica</a></li>
                <li><a href="?album=italia">Viaje a Italia</a></li>
            </ul>
        </nav>
    </header>

    <main>
        <!-- foto -->
        <div id="imagen">
            
            <?php
            if (isset($albunes[$carpetaSelecionada])) {
                if ($posicion < 0) $posicion = 0;
                if ($posicion >= count($albunes[$carpetaSelecionada]))
                    $posicion = count($albunes[$carpetaSelecionada]) - 1;
                echo "<img src='" . $albunes[$carpetaSelecionada][$posicion] . "'>";
            } else {
                echo "<img src='../imagenes/noimagen.png' alt='Portada' id='portada'>";
            }
            ?>
        </div>
        <!-- botones -->
        <div>
            <?php
            if (isset($albunes[$carpetaSelecionada])) {
                $todasFotos = count($albunes[$carpetaSelecionada]);
                $anterior = ($posicion - 1 + $todasFotos) % $todasFotos;
                $siguiente = ($posicion + 1) % $todasFotos;
                
                echo "<a href='?album=$carpetaSelecionada&foto=$anterior'> Anterior </a>";
                echo "<a href='?album=$carpetaSelecionada&foto=$siguiente'> Siguente </a>";
            }
            ?>
        </div>
    </main>
    <div id="menu">
        <a href="../../index.html"> Volver a la pagina Principal </a>
    </div>

</body>

</html>




